<?php
require_once 'config.php';
require_once 'header.php';

// Redirect if not logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

$user_id = $_SESSION['user_id'];

// Handle grievance submission (if form is posted)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit_grievance'])) {
    $subject = trim($_POST['subject'] ?? '');
    $description = trim($_POST['description'] ?? '');

    if (empty($subject) || empty($description)) {
        $error = 'Subject and description are required.';
    } else {
        $stmt = $pdo->prepare("INSERT INTO grievances (user_id, subject, description) VALUES (?, ?, ?)");
        if ($stmt->execute([$user_id, $subject, $description])) {
            $success = 'Grievance submitted successfully.';
        } else {
            $error = 'Submission failed. Please try again.';
        }
    }
}

// Fetch user's grievances
$stmt = $pdo->prepare("SELECT * FROM grievances WHERE user_id = ? ORDER BY created_at DESC");
$stmt->execute([$user_id]);
$grievances = $stmt->fetchAll();
?>

<h2>Welcome, <?= htmlspecialchars($_SESSION['user_name']) ?></h2>

<h3>Submit a New Grievance</h3>
<?php if (isset($error)): ?><p class="error"><?= htmlspecialchars($error) ?></p><?php endif; ?>
<?php if (isset($success)): ?><p class="success"><?= htmlspecialchars($success) ?></p><?php endif; ?>

<form method="post">
    <label for="subject">Subject:</label>
    <input type="text" name="subject" id="subject" required>

    <label for="description">Description:</label>
    <textarea name="description" id="description" rows="5" required></textarea>

    <button type="submit" name="submit_grievance">Submit Grievance</button>
</form>

<h3>Your Previous Grievances</h3>
<?php if (count($grievances) > 0): ?>
    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Subject</th>
                <th>Status</th>
                <th>Submitted On</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($grievances as $g): ?>
            <tr>
                <td><?= $g['id'] ?></td>
                <td><?= htmlspecialchars($g['subject']) ?></td>
                <td><?= ucfirst(str_replace('_', ' ', $g['status'])) ?></td>
                <td><?= date('d M Y, h:i A', strtotime($g['created_at'])) ?></td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
<?php else: ?>
    <p>You haven't submitted any grievances yet.</p>
<?php endif; ?>

<?php require_once 'footer.php'; ?>